<?php
include "../config/koneksi.php";

if (!isset($_GET['id'])) {
    die("ID tidak valid");
}

$id = (int)$_GET['id'];

/* =========================
   DATA MASTER
========================= */
$jabatan = $conn->query("SELECT * FROM jabatan");
$fraksi  = $conn->query("SELECT * FROM fraksi");
$komisi  = $conn->query("SELECT * FROM komisi");
$akd     = $conn->query("SELECT * FROM akd");

/* =========================
   DATA USER
========================= */
$userQ = $conn->prepare("SELECT * FROM user WHERE id=?");
$userQ->bind_param("i", $id);
$userQ->execute();
$user = $userQ->get_result()->fetch_assoc();

if (!$user) {
    die("Data tidak ditemukan");
}

/* =========================
   AKD USER
========================= */
$akdUser = [];
$akdQ = $conn->query("SELECT akd_id FROM user_akd WHERE user_id=$id");
while ($a = $akdQ->fetch_assoc()) {
    $akdUser[] = $a['akd_id'];
}

/* =========================
   UPDATE DATA
========================= */
if (isset($_POST['update'])) {

    $nama       = $_POST['nama'];
    $jabatan_id = $_POST['jabatan_id'];
    $fraksi_id  = $_POST['fraksi_id'] ?: NULL;
    $komisi_id  = $_POST['komisi_id'] ?: NULL;

    /* FOTO */
    $foto = $user['foto'];
    if (!empty($_FILES['foto']['name'])) {
        $fotoBaru = time() . '.jpg';
        $path = "../uploads/user/" . $fotoBaru;
        move_uploaded_file($_FILES['foto']['tmp_name'], $path);

        if (file_exists("../uploads/user/" . $foto)) {
            unlink("../uploads/user/" . $foto);
        }
        $foto = $fotoBaru;
    }

    /* UPDATE USER */
    $stmt = $conn->prepare("
        UPDATE user SET
        nama=?, foto=?, jabatan_id=?, fraksi_id=?, komisi_id=?
        WHERE id=?
    ");
    $stmt->bind_param(
        "ssiiii",
        $nama,
        $foto,
        $jabatan_id,
        $fraksi_id,
        $komisi_id,
        $id
    );
    $stmt->execute();

    /* RESET AKD */
    $conn->query("DELETE FROM user_akd WHERE user_id=$id");

    if (!empty($_POST['akd_id'])) {
        $stmtAkd = $conn->prepare("
            INSERT INTO user_akd (user_id, akd_id)
            VALUES (?,?)
        ");
        foreach ($_POST['akd_id'] as $akd_id) {
            $stmtAkd->bind_param("ii", $id, $akd_id);
            $stmtAkd->execute();
        }
    }

    echo "<script>
        alert('Data berhasil diperbarui');
        window.location='kelola_anggota.php';
    </script>";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="icon" href="../assets/img/dprdlogo.png">
<title>Ubah Anggota DPRD</title>

<link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700" rel="stylesheet">
<link href="../assets/css/argon-dashboard.css?v=2.1.0" rel="stylesheet">

<style>
html, body { height: 100%; }
body { display: flex; }
.g-sidenav-show { display: flex; flex-direction: column; width: 100%; }
.main-content { flex: 1; display: flex; flex-direction: column; }
.footer { margin-top: auto; background: #fff; }
</style>
</head>

<body class="g-sidenav-show bg-gray-100">
<div class="min-height-300 bg-dark position-absolute w-100"></div>

<!-- ================= SIDEBAR ================= -->
<aside class="sidenav bg-white navbar navbar-vertical navbar-expand-xs border-0 border-radius-xl my-3 fixed-start ms-4">
  <div class="sidenav-header">
    <a class="navbar-brand m-0">
      <img src="../assets/img/dprdlogo.png" width="26">
      <span class="ms-1 font-weight-bold">Admin DPRD</span>
    </a>
  </div>
  <hr class="horizontal dark mt-0">
  <div class="collapse navbar-collapse w-auto">
    <ul class="navbar-nav">
      <li class="nav-item">
        <a class="nav-link" href="../pages/dashboard.html">Dashboard</a>
      </li>
      <li class="nav-item">
        <a class="nav-link active" href="kelola_anggota.php">Kelola Anggota</a>
      </li>
    </ul>
  </div>
</aside>

<!-- ================= MAIN ================= -->
<main class="main-content position-relative border-radius-lg">

<nav class="navbar navbar-main navbar-expand-lg px-0 mx-4 shadow-none">
  <div class="container-fluid py-1 px-3">
    <h6 class="text-white mb-0">Ubah Data Anggota DPRD</h6>
  </div>
</nav>

<div class="container-fluid py-4">

<div class="card">
  <div class="card-header pb-0">
    <h6>Form Ubah Anggota</h6>
  </div>

  <div class="card-body">
    <form method="POST" enctype="multipart/form-data">
      <div class="row">

        <div class="col-md-6 mb-3">
          <label>Nama Lengkap</label>
          <input type="text" name="nama" class="form-control"
                 value="<?= htmlspecialchars($user['nama']) ?>" required>
        </div>

        <div class="col-md-6 mb-3">
          <label>Foto (opsional)</label>
          <input type="file" name="foto" class="form-control">
          <small class="text-muted">Foto saat ini:</small><br>
          <img src="../uploads/user/<?= $user['foto'] ?>"
               class="rounded mt-2" width="80">
        </div>

        <div class="col-md-4 mb-3">
          <label>Jabatan</label>
          <select name="jabatan_id" class="form-control" required>
          <?php while($j=$jabatan->fetch_assoc()): ?>
            <option value="<?= $j['id'] ?>"
              <?= $user['jabatan_id']==$j['id']?'selected':'' ?>>
              <?= $j['nama_jabatan'] ?>
            </option>
          <?php endwhile; ?>
          </select>
        </div>

        <div class="col-md-4 mb-3">
          <label>Fraksi</label>
          <select name="fraksi_id" class="form-control">
            <option value="">-- Kosong --</option>
            <?php while($f=$fraksi->fetch_assoc()): ?>
              <option value="<?= $f['id'] ?>"
                <?= $user['fraksi_id']==$f['id']?'selected':'' ?>>
                <?= $f['nama_fraksi'] ?>
              </option>
            <?php endwhile; ?>
          </select>
        </div>

        <div class="col-md-4 mb-3">
          <label>Komisi</label>
          <select name="komisi_id" class="form-control">
            <option value="">-- Kosong --</option>
            <?php while($k=$komisi->fetch_assoc()): ?>
              <option value="<?= $k['id'] ?>"
                <?= $user['komisi_id']==$k['id']?'selected':'' ?>>
                <?= $k['nama_komisi'] ?>
              </option>
            <?php endwhile; ?>
          </select>
        </div>

        <div class="col-md-12 mb-4">
          <label>AKD (boleh lebih dari satu)</label>
          <select name="akd_id[]" class="form-control" multiple>
            <?php while($a=$akd->fetch_assoc()): ?>
              <option value="<?= $a['id'] ?>"
                <?= in_array($a['id'], $akdUser)?'selected':'' ?>>
                <?= $a['nama_akd'] ?>
              </option>
            <?php endwhile; ?>
          </select>
          <small class="text-muted">Tahan CTRL untuk pilih lebih dari satu</small>
        </div>

      </div>

      <div class="d-flex gap-2">
        <button type="submit" name="update" class="btn btn-warning">
          Simpan Perubahan
        </button>
        <a href="kelola_anggota.php" class="btn btn-secondary">
          Batal
        </a>
      </div>

    </form>
  </div>
</div>

</div>

<footer class="footer pt-3 text-center text-muted">
© 2025 Admin DPRD
</footer>

</main>

<script src="../assets/js/core/bootstrap.min.js"></script>
<script src="../assets/js/argon-dashboard.min.js?v=2.1.0"></script>
</body>
</html>
