<?php
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);

include __DIR__ . "/../config/koneksi.php";

// =======================
// VALIDASI ID
// =======================
$id = $_GET['id'] ?? '';
$id = mysqli_real_escape_string($conn, $id);

if ($id === '') {
    echo json_encode([
        "status" => false,
        "message" => "ID tidak boleh kosong",
        "data" => null
    ]);
    exit;
}

// =======================
// QUERY + AKD (GROUP_CONCAT)
// =======================
$sql = "
    SELECT 
        u.id,
        u.nama,
        IFNULL(j.nama_jabatan, '-') AS jabatan,
        IFNULL(f.nama_fraksi, '-') AS fraksi,
        IFNULL(k.nama_komisi, '-') AS komisi,
        IFNULL(
            GROUP_CONCAT(a.nama_akd SEPARATOR ', '),
            '-'
        ) AS akd,
        IFNULL(u.foto, '') AS foto
    FROM user u
    LEFT JOIN jabatan j ON u.jabatan_id = j.id
    LEFT JOIN fraksi f ON u.fraksi_id = f.id
    LEFT JOIN komisi k ON u.komisi_id = k.id
    LEFT JOIN user_akd ua ON ua.user_id = u.id
    LEFT JOIN akd a ON ua.akd_id = a.id
    WHERE u.id = '$id'
    GROUP BY u.id
    LIMIT 1
";

$q = mysqli_query($conn, $sql);

if (!$q) {
    echo json_encode([
        "status" => false,
        "message" => "Query error",
        "error" => mysqli_error($conn),
        "sql" => $sql,
        "data" => null
    ]);
    exit;
}

$data = mysqli_fetch_assoc($q);

// =======================
// USER TIDAK ADA
// =======================
if (!$data || !$data['id']) {
    echo json_encode([
        "status" => false,
        "message" => "User dengan ID tersebut tidak ditemukan",
        "data" => null
    ]);
    exit;
}

// =======================
// RESPONSE SUKSES
// =======================
echo json_encode([
    "status" => true,
    "data" => [
        "id" => $data['id'],
        "nama" => $data['nama'],
        "jabatan" => $data['jabatan'],
        "fraksi" => $data['fraksi'],
        "komisi" => $data['komisi'],
        "akd" => $data['akd'],   // 🔥 INI AKD
        "foto" => $data['foto']
    ]
]);
